import networkx as nx
import numpy as np
import matplotlib.pyplot as plt

def DrawResGraph(fn):
    bonds = []
    with open(fn, "r") as fd:
        lines = fd.readlines()
        for line in lines:
            words = line.split()
            bonds.append((int(words[0]),int(words[1])))
    g = nx.Graph()
    g.add_edges_from(bonds)
    #pos = nx.spring_layout(g)
    pos = nx.kamada_kawai_layout(g)
    ws = np.array([i for i in range(g.number_of_nodes())])
    # Visualize the network.
    nx.draw(g, pos, with_labels = False, node_size = 20, cmap = plt.cm.Oranges, node_color = ws)
    # Calculate properties.
    assortativity = nx.degree_assortativity_coefficient(g)
    transitivity = nx.transitivity(g)
    print("Assortativity: %.8f" % assortativity)
    print("Transitivity:  %.8f" % transitivity)
    #print(nx.average_neighbor_degree(g))    
    plt.show()

if __name__ == "__main__":
    fn = ""
    DrawResGraph(fn)
    
    
    